﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ITA_580
{
    public partial class Form1
    {
        public static byte SMBUS_CHANNEL = 0;

        public static byte gSmb0 = 0;

        private void CheckSmbus()
        {
            byte num;
            byte mask;

            num = AecSmbGetNum(gPtrAecInit);
            if (num > 0)
            {
                mask = 0;
                AecSmbGetChannelMask(gPtrAecInit, ref mask);
                if ((mask & 0x01) == 0x01)    //check smbus channel 0 can use
                {
                    gSmb0 = 1;    //can use
                }
                else
                {
                    gSmb0 = 0;    //can't use
                }
            }
        }

        private void CheckSmbusPeripheral()
        {
            byte res;

            CheckSmbus();

            if (gSmb0 == 1)
            {
                //check ltc3350 in bus
                res = AecSmbProbe(gPtrAecInit, SMBUS_CHANNEL, LTC3350_ADDRESS);
                if (res == 0)   //ltc3350 in bus
                {
                    gLtc3350 = 1;

                    label1.Enabled = true;
                    groupBox1.Enabled = true;
                }
                else   //ltc3350 not in bus
                {
                    gLtc3350 = 0;

                    label1.Enabled = false;
                    groupBox1.Enabled = false;
                }

                //check tca9554 in bus
                res = AecSmbProbe(gPtrAecInit, SMBUS_CHANNEL, TCA9554_ADDRESS);
                if (res == 0)   //tca9554 in bus
                {
                    gTca9554 = 1;

                    label66.Enabled = true;
                    label18.Enabled = true;
                    label50.Enabled = true;
                    label52.Enabled = true;

                    radioButton12.Enabled = true;
                    radioButton13.Enabled = true;
                    radioButton15.Enabled = true;
                    radioButton16.Enabled = true;
                    radioButton18.Enabled = true;
                    radioButton19.Enabled = true;
                    radioButton21.Enabled = true;
                    radioButton22.Enabled = true;
                }
                else   //tca9554 not in bus
                {
                    gTca9554 = 0;

                    label66.Enabled = false;
                    label18.Enabled = false;
                    label50.Enabled = false;
                    label52.Enabled = false;

                    radioButton12.Enabled = false;
                    radioButton13.Enabled = false;
                    radioButton15.Enabled = false;
                    radioButton16.Enabled = false;
                    radioButton18.Enabled = false;
                    radioButton19.Enabled = false;
                    radioButton21.Enabled = false;
                    radioButton22.Enabled = false;
                }
            }
        }
    }
}
